/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.builder.AbstractBuildPath;
import com.aptana.editor.php.internal.builder.FolderFilteringManager;
import com.aptana.editor.php.internal.builder.LocalDirectory;
import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.builder.PHPLocalModuleFactory;
import com.aptana.editor.php.internal.core.builder.IBuildPathResource;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class WorkspaceFolderBuildpath
extends AbstractBuildPath {
    private IFolder folder;

    public WorkspaceFolderBuildpath(IFolder folder) {
        this.folder = folder;
    }

    public IFolder getFolder() {
        return this.folder;
    }

    public IPath getResourcePath(IBuildPathResource resource) {
        if (resource instanceof LocalModule) {
            IPath filePath;
            IFile moduleFile = ((LocalModule)resource).getFile();
            IPath folderPath = this.folder.getFullPath();
            if (!folderPath.isPrefixOf(filePath = moduleFile.getFullPath())) {
                return null;
            }
            return filePath.removeFirstSegments(folderPath.segmentCount()).makeAbsolute();
        }
        if (resource instanceof LocalDirectory) {
            IPath fldPath;
            IContainer fld = ((LocalDirectory)resource).getContainer();
            IPath folderPath = this.folder.getFullPath();
            if (!folderPath.isPrefixOf(fldPath = fld.getFullPath())) {
                return null;
            }
            return fldPath.removeFirstSegments(folderPath.segmentCount()).makeAbsolute();
        }
        return null;
    }

    public void close() {
    }

    public IModule getModule(Object moduleResource) {
        if (!(moduleResource instanceof IFile)) {
            return null;
        }
        IFile moduleFile = (IFile)moduleResource;
        if (!moduleFile.getProject().equals((Object)this.folder.getProject())) {
            return null;
        }
        IPath modulePath = moduleFile.getProjectRelativePath();
        IPath folderPath = this.folder.getProjectRelativePath();
        if (!folderPath.isPrefixOf(modulePath)) {
            return null;
        }
        return PHPLocalModuleFactory.getModule((IResource)moduleResource, this);
    }

    public IModule getModuleByPath(IPath path) {
        IFile file = this.folder.getFile(path);
        if (file == null || !file.exists()) {
            return null;
        }
        return PHPLocalModuleFactory.getModule((IResource)file, this);
    }

    public List<IModule> getModules() {
        return this.indexLocalModules();
    }

    public boolean isPassive() {
        return true;
    }

    public List<IModule> getModulesByPath(IPath path) {
        IFolder pathFolder = this.folder.getFolder(path);
        if (pathFolder == null || !pathFolder.exists()) {
            return null;
        }
        IResource[] innerResources = null;
        try {
            innerResources = pathFolder.members();
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error getting modules by path", (Throwable)e, (String)"com.aptana.editor.php/debug");
            return null;
        }
        ArrayList<IFile> innerFiles = new ArrayList<IFile>();
        IResource[] iResourceArray = innerResources;
        int n = innerResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource innerResource = iResourceArray[n2];
            if (innerResource instanceof IFile && ((IFile)innerResource).exists()) {
                innerFiles.add((IFile)innerResource);
            }
            ++n2;
        }
        ArrayList<IModule> result = new ArrayList<IModule>();
        for (IFile innerFile : innerFiles) {
            IModule currentModule = this.getModule(innerFile);
            if (currentModule == null) continue;
            result.add(currentModule);
        }
        return result;
    }

    public List<IDirectory> getSubdirectoriesByPath(IPath path) {
        IFolder pathFolder = this.folder.getFolder(path);
        if (pathFolder == null || !pathFolder.exists()) {
            return null;
        }
        IResource[] innerResources = null;
        try {
            innerResources = pathFolder.members();
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error getting sub-directories by path", (Throwable)e, (String)"com.aptana.editor.php/debug");
            return null;
        }
        ArrayList<IFolder> innerFolders = new ArrayList<IFolder>();
        IResource[] iResourceArray = innerResources;
        int n = innerResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource innerResource = iResourceArray[n2];
            if (innerResource instanceof IFolder && ((IFolder)innerResource).exists()) {
                innerFolders.add((IFolder)innerResource);
            }
            ++n2;
        }
        ArrayList<IDirectory> result = new ArrayList<IDirectory>();
        for (IFolder innerFolder : innerFolders) {
            if (!innerFolder.isAccessible()) continue;
            LocalDirectory currentDir = new LocalDirectory((IContainer)innerFolder, this);
            result.add(currentDir);
        }
        return result;
    }

    public IDirectory getDirectory(Object directoryResource) {
        if (!(directoryResource instanceof IFolder)) {
            return null;
        }
        if (!((IFolder)directoryResource).isAccessible()) {
            return null;
        }
        return new LocalDirectory((IContainer)((IFolder)directoryResource), this);
    }

    public IDirectory getDirectoryByPath(IPath path) {
        if (path.segmentCount() == 0) {
            return null;
        }
        IFolder fld = this.folder.getFolder(path);
        if (fld == null || !fld.isAccessible()) {
            return null;
        }
        return new LocalDirectory((IContainer)fld, this);
    }

    public boolean contains(IModule module) {
        if (!(module instanceof LocalModule)) {
            return false;
        }
        return this.getModule(((LocalModule)module).getFile()) != null;
    }

    private List<IModule> indexLocalModules() {
        final ArrayList<IModule> toReturn = new ArrayList<IModule>();
        if (!this.folder.isSynchronized(1)) {
            return toReturn;
        }
        try {
            this.folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (!resource.isAccessible()) {
                        return false;
                    }
                    if (resource instanceof IFolder) {
                        if (!resource.isSynchronized(1)) {
                            return false;
                        }
                        if (!FolderFilteringManager.acceptFolder((IFolder)resource)) {
                            return false;
                        }
                    }
                    if (!(resource instanceof IFile)) {
                        return true;
                    }
                    IModule module = PHPLocalModuleFactory.getModule(resource, WorkspaceFolderBuildpath.this);
                    if (module != null) {
                        toReturn.add(module);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error indexing local modules", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
            return null;
        }
        return toReturn;
    }

    public String getHandleIdentifier() {
        return String.valueOf('W') + this.folder.getFullPath().toPortableString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkspaceFolderBuildpath) {
            return ((WorkspaceFolderBuildpath)obj).folder.equals((Object)this.folder);
        }
        return false;
    }

    public int hashCode() {
        return this.folder.hashCode();
    }
}

